;**********************************************
; Test write and read RTC pcf8583
; Hardware  : CP-PIC V3.0 & V4.0
; OSC	    : 10 MHZ [HS MODE]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 3/8/2002
;**********************************************

     LIST P=16f877
     include <p16f877.inc>
   __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _XT_OSC & _WRT_ENABLE_ON & _LVP_ON & _DEBUG_OFF & _CPD_OFF
#define        SDA  PORTC,4
#define        SCL  PORTC,3

dt1       EQU       0x20
dt2       EQU       0x21
dt3       EQU       0x22
XBUF      EQU       0x23
count     EQU       0x24
CONTROL   EQU       0x25
ADD       EQU       0x27
DAT       EQU       0x28
flag      EQU       0x29
DOUT      EQU       0x30
B1        EQU       0x31
B2        EQU       0x32

WRITE_BUFFER	EQU     0X33
COUNT8		EQU	0X34
READ_BUFFER	EQU	0X35

;*********************************************
          ORG       0x0000
          bsf       STATUS,RP0     ; select bank 1
          bcf       TRISC,4
          bcf       TRISC,3
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       TXSTA,TXEN     ; Transmit enable
	  bsf	    TXSTA,BRGH     ; hi speed    
          bcf       STATUS,RP0     ; select bank 0
          clrf      RCSTA
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive

          CALL	    START
	  movlw     0xA2            
          CALL	    WRITE
          movlw     0x02            
          call      WRITE           ; call write sub
	  MOVLW     0X00            
	  CALL	    WRITE           ; Write secound by 00
	  MOVLW     0X00
	  CALL	    WRITE           ; Write minute by 00
	  MOVLW     0X00
	  CALL	    WRITE	    ; Write Hour by 00
          call      SDel           ; delay 

st        movlw     0x0C           ; Clear display
          call      SEND
          movlw     "H"
          call      SEND
          movlw     "O"
          call      SEND
          movlw     "U"
          call      SEND
          movlw     "R"
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
         
	  movlw     "M"
          call      SEND
          movlw     "I"
          call      SEND
          movlw     "N"
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
          movlw     "S"
          call      SEND
          movlw     "E"
          call      SEND
          movlw     "C"
          call      SEND
          movlw     0xA             ; new line
          call      SEND
          movlw     0xD
          call      SEND
 	  movlw     " "
	  call      SEND

;*********** READ HOUR *************
          call	    START
          movlw     0xA2           ; Read minute
          call	    WRITE
	  movlw	    0x04	   ; address minute = 04h
	  call	    WRITE
	  call	    STOP
	  call	    START
	  movlw	    0xA3	   ; control read
	  call	    WRITE
	  call	    READ_DATA	   ; read data form rtc 
          movf      READ_BUFFER,w
          call      ADJT            ; display minute

	  movlw     " "
          call      SEND
          movlw     ":"
          call      SEND
          movlw     " "
          call      SEND
	  movlw     " "
          call      SEND

;*********** READ Min *************
          call	    START
          movlw     0xA2           ; Read minute
          call	    WRITE
	  movlw	    0x03
	  call	    WRITE
	  call	    STOP
	  call	    START
	  movlw	    0xA3
	  call	    WRITE
	  call	    READ_DATA	     
          movf      READ_BUFFER,w
          call      ADJT            ; display minute
          
          movlw     " "
          call      SEND
          movlw     ":"
          call      SEND
          movlw     " "
          call      SEND
	 

;******** READ SEC *********
	  
          call	    START
          movlw     0xA2            ; Read second
          call	    WRITE
	  movlw	    0x02
	  call	    WRITE
	  call	    STOP
	  call	    START
	  movlw	    0xA3
	  call	    WRITE
	  call	    READ_DATA	     
          movf      READ_BUFFER,w
          call      ADJT            ; display second
	  call      SDel
	  CALL      SDel
          goto      st

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      movwf     B1             ; B1 = HHHH LLLL
          swapf     B1,w           ; W  = LLLL HHHH
          andlw     0x0f           ; Mask upper four bits 0000 HHHH
          addlw     0x30           ; convert to ASCII
          call      SEND           ; Send first digit
          movf      B1,w
          andlw     0x0f           ; w  = 0000 LLLL
          addlw     0x30           ; convert to ASCII
          call      SEND
          return

;********************************************************
; Send data to RS-232 2400 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      movwf     TXREG          ; Send recent data to TX 
wait1     movlw     TXSTA
          movwf     FSR
          btfss     INDF,1         ; check TRMT bit in TXSTA register
          goto      wait1          ; TXREG full  or TRMT = 0
          return

;************************************
; Write data
; Input   : ADD,DAT
; Output  : EEPROM
;************************************
WRITE		
		MOVWF	WRITE_BUFFER
		MOVLW	.8
		MOVWF	COUNT8
		CALL	SCL_LOW
WRITE_LOOP
		RLF	WRITE_BUFFER,1
		BC	SEND_1
SEND_0		
		CALL    SDA_LOW
		CALL	SCL_PULSE
		GOTO	CHECK
SEND_1	
		CALL	SDA_HIGH
		CALL	SCL_PULSE
CHECK
		DECFSZ	COUNT8,1
		GOTO	WRITE_LOOP
		CALL	SDA_HIGH
		CALL	READ_ACK
		RETURN 


;************************************
; Read data
; Input   : ADD
; Output  : DOUT
;************************************
READ_DATA
		MOVLW	.8
		MOVWF	COUNT8
		CALL	SCL_LOW
		CALL	SDA_HIGH
READ_LOOP	
		CALL	SCL_HIGH
		BTFSC	SDA
		GOTO	RECEIVE_1
RECEIVE_0
		CLRC
		GOTO	ROTATE_DATA
RECEIVE_1	
		SETC
ROTATE_DATA	
		RLF	READ_BUFFER,1
		CALL	SCL_LOW
		DECFSZ	COUNT8,1
		GOTO	READ_LOOP
		RETURN

;******************************
; Start bit
;******************************
START
		CALL	SDA_HIGH
		CALL	SCL_HIGH
		BTFSS	SCL
		GOTO	$-1
		BTFSS	SDA
		GOTO	$-1
		CALL	SDA_LOW
		CALL	SCL_LOW
		RETURN

;********  STOP *************
STOP
		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SDA_HIGH
		CALL	DELAY5
		RETURN

;********** SCL HIGH ********************
SCL_HIGH	
		BANKSEL TRISC
		BSF	TRISC,3
		CALL	DELAY5
		BANKSEL	PORTC
		RETURN

;********* DELAY 5 uS *******************
DELAY5	
		NOP
		GOTO	$+1
		RETURN

;******** SCL LOW **********************
SCL_LOW
		BANKSEL	TRISC
		BCF	TRISC,3
		BANKSEL	PORTC
		BCF	SCL
		CALL	DELAY5
		RETURN

;******** SDA HIGH ********************
SDA_HIGH	
		BANKSEL	TRISC
		BSF	TRISC,4
		BANKSEL	PORTC
		RETURN

;********  SDA  LOW *****************
SDA_LOW		
		BANKSEL	TRISC
		BCF	TRISC,4
		BANKSEL	PORTC
		BCF	SDA
		RETURN

;******** SCL PULSE *************** 
SCL_PULSE	
		CALL	SCL_LOW
		CALL	SCL_HIGH
		CALL	SCL_LOW
		RETURN

;********  READ ACK **************
READ_ACK
		CALL	SDA_HIGH
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA
		GOTO	STOP
		BTFSS	SCL
		GOTO	$-1
		CALL	SCL_LOW
		RETURN

;*********** ACK POLLING **********
ACK_POLLING	
		CALL	SCL_LOW
		CALL	START
		MOVLW	B'10100000'
		CALL	WRITE
WRITE_WAIT
		CALL	SDA_HIGH
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA
		GOTO	ACK_POLLING
		CALL	SCL_LOW
		RETURN

;******** SEND ACK ************
SEND_ACK
		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SCL_LOW
		CALL	SDA_HIGH
		RETURN


;********  SEND NACK *********
SEND_NACK
		CALL	SCL_LOW
		CALL	SDA_HIGH
		CALL	SCL_HIGH
		CALL	SCL_LOW
		RETURN

;******************************
; Short delay
;******************************

SDel      movlw     0x00
          movwf     dt1
sd2       movlw     0x00
          movwf     dt2
sd1       decfsz    dt2
          goto      sd1
          decfsz    dt1
          goto      sd2
          return
          end
;****************** END OF PROGRAM ************************

